% Tables_2_3.m
% 
% Tables of forecasts
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 

% -- Clear Workspace -- %
restoredefaultpath;
clear;
clc;
close all;

% -- File Directories -- % 
datadir = 'Data\DataReplication\DataFinal\'; 
outdir  = 'Tables\';
figdir  = 'Figures\';
matdir  = 'Output\';

% -- Add paths -- %
addpath('Functions\');
addpath('Utilities\')
addpath('Data\')

% -- Load Data and Setup -- %
load([matdir 'VA_Shares_Components_Trends.mat']);
period_lower = 20;       % Shortest Period 
Share_mat = va_shares_trend;
T_is = size(Share_mat,1);
nS = size(Share_mat,2);

% Compute q
q_is = floor(2*T_is/period_lower);

% Read in Univariate Forecasts
% Value-added shares
load([matdir 'fcst_va_shares_V1_' num2str(q_is) '.mat']);
va_share_is_v1 = Share_is;
va_shareproj_is_v1 = Shareproj_is;
va_shareproj_os_mean_v1 = Shareproj_os_mean;
va_shareproj_os_quantiles_v1 = Shareproj_os_quantiles;
va_shareproj_os_d2018_quantiles_v1 = Shareproj_os_d2018_quantiles;
va_share_os_trend_only_v1 = Share_os_trend_only;
va_share_os_trend_v1 = Share_os_trend;
T = size(va_share_is_v1,1);
calvec_os = calvec(1) + (0:1:T-1)';


% -- Tables 2 and 3 -- %
% year for the forecast 
fcst_year = 2038;
T_fcst = find(calvec_os == fcst_year);
va_share_proj_1947_v1   = 100*va_shareproj_is_v1(1,:);
va_share_proj_2018_v1   = 100*va_shareproj_is_v1(T_is,:);
va_share_proj_fcst_v1   = 100*va_shareproj_os_mean_v1(T_fcst,:);
va_share_67_lower       = 100*va_shareproj_os_quantiles_v1(T_fcst,:,2);
va_share_67_upper       = 100*va_shareproj_os_quantiles_v1(T_fcst,:,4);
va_share_90_lower       = 100*va_shareproj_os_quantiles_v1(T_fcst,:,1);
va_share_90_upper       = 100*va_shareproj_os_quantiles_v1(T_fcst,:,5);
va_share_d2018_67_lower = 100*va_shareproj_os_d2018_quantiles_v1(T_fcst,:,2);
va_share_d2018_67_upper = 100*va_shareproj_os_d2018_quantiles_v1(T_fcst,:,4);
va_share_d2018_90_lower = 100*va_shareproj_os_d2018_quantiles_v1(end,:,1);
va_share_d2018_90_upper = 100*va_shareproj_os_d2018_quantiles_v1(end,:,5);

% Open a file to write the results
fname = [outdir 'Tables_2_3.csv'];
fid = fopen(fname,'w');
% Write some baseline values
fprintf(fid,'Value-Added Shares Forecasts \n\n');
fprintf(fid,'Sector,,');
for i = 1:5
    fprintf(fid,'%s,',SecName{i});
end
fmt_str = '%8.1f,';
fmt2_str = '%8.1f %8.1f,';

fprintf(fid,'\n');
fprintf(fid,'Levels \n');
fprintf(fid,'Actual,');
fprintf(fid,'1947,');
fprintf(fid,fmt_str,va_share_proj_1947_v1);
fprintf(fid,'\n');
fprintf(fid,'Actual,');
fprintf(fid,'2018,');
fprintf(fid,fmt_str,va_share_proj_2018_v1);
fprintf(fid,'\n');
fprintf(fid,'Forecast for, %4i,',fcst_year);
fprintf(fid,fmt_str,va_share_proj_fcst_v1);
fprintf(fid,'\n');
fprintf(fid,'68 Percent PI,,');
for i = 1:5
    fprintf(fid,fmt2_str,[va_share_67_lower(i),va_share_67_upper(i)]);
end
fprintf(fid,'\n');
fprintf(fid,'\n');
fprintf(fid,'Change: 1947-2018 \n');
fprintf(fid,'Actual Change, 1947-2018,');
fprintf(fid,fmt_str,va_share_proj_2018_v1-va_share_proj_1947_v1);
fprintf(fid,'\n');
fprintf(fid,'20 Year Hist Avg, 1947-2018,');
fprintf(fid,fmt_str,20/72*(va_share_proj_2018_v1-va_share_proj_1947_v1));
fprintf(fid,'\n');
fprintf(fid,'Forecast Change, 2018-2038,');
fprintf(fid,fmt_str,va_share_proj_fcst_v1-va_share_proj_2018_v1);
fprintf(fid,'\n');
fprintf(fid,'68 Percent PI,,');
for i = 1:5
    fprintf(fid,fmt2_str,[va_share_d2018_67_lower(i),va_share_d2018_67_upper(i)]);
end
fprintf(fid,'\n');

% Read in the Forecasts of the parameters
% theta shares
load([matdir 'fcst_theta_shares_V1_' num2str(q_is) '.mat']);
theta_share_is_v1 = Share_is;
theta_shareproj_is_v1 = Shareproj_is;
theta_shareproj_os_mean_v1 = Shareproj_os_mean;
theta_share_os_trend_only_v1 = Share_os_trend_only;
theta_share_os_trend_v1 = Share_os_trend;

% Omega shares
load([matdir 'fcst_Omega_shares_V1_' num2str(q_is) '.mat']);
Omega_share_is_v1 = Share_is_mat;
Omega_shareproj_is_v1 = Shareproj_is_mat;
Omega_shareproj_os_mean_v1 = Shareproj_os_mean_mat;
Omega_share_os_trend_only_v1 = Share_os_trend_only_mat;
Omega_share_os_trend_v1 = Share_os_trend_mat;

% Omega shares
load([matdir 'fcst_Phi_shares_V1_' num2str(q_is) '.mat']);
Phi_share_is_v1 = Share_is_mat;
Phi_shareproj_is_v1 = Shareproj_is_mat;
Phi_shareproj_os_mean_v1 = Shareproj_os_mean_mat;
Phi_share_os_trend_only_v1 = Share_os_trend_only_mat;
Phi_share_os_trend_v1 = Share_os_trend_mat;

% Gamma
load([matdir 'fcst_gamma_V1_' num2str(q_is) '.mat']);
gamma_Y_is_v1 = Y_is;
gamma_Yproj_is_v1 = Yproj_is;
gamma_Yproj_os_mean_v1 = Yproj_os_mean;
gamma_Y_os_trend_only_v1 = trend_os_only;
gamma_Y_os_trend_v1 = Y_os_trend;

% psiX
load([matdir 'fcst_psiX_V1_' num2str(q_is) '.mat']);
psiX_Y_is_v1 = Y_is;
psiX_Yproj_is_v1 = Yproj_is;
psiX_Yproj_os_mean_v1 = Yproj_os_mean;
psiX_Y_os_trend_only_v1 = trend_os_only;
psiX_Y_os_trend_v1 = Y_os_trend;

% psiX
load([matdir 'fcst_psiNX_V1_' num2str(q_is) '.mat']);
psiNX_Y_is_v1 = Y_is;
psiNX_Yproj_is_v1 = Yproj_is;
psiNX_Yproj_os_mean_v1 = Yproj_os_mean;
psiNX_Y_os_trend_only_v1 = trend_os_only;
psiNX_Y_os_trend_v1 = Y_os_trend;

% psiG
load([matdir 'fcst_psiG_V1_' num2str(q_is) '.mat']);
psiG_Y_is_v1 = Y_is;
psiG_Yproj_is_v1 = Yproj_is;
psiG_Yproj_os_mean_v1 = Yproj_os_mean;
psiG_Y_os_trend_only_v1 = trend_os_only;
psiG_Y_os_trend_v1 = Y_os_trend;

% Compute some mean forecasts of VA shares
% V2 Uses the mean forecasts from the components
va_shareproj_os_mean_v2 = zeros(size(Share_is));
for t = 1:T
    theta = theta_shareproj_os_mean_v1(t,:)';
    gamma = gamma_Yproj_os_mean_v1(t,:)';
    psiX = psiX_Yproj_os_mean_v1(t,:)';
    psiG = psiG_Yproj_os_mean_v1(t,:)';
    psiNX = psiNX_Yproj_os_mean_v1(t,:)';
    Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,t));
    Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,t));
    va_shareproj_os_mean_v2(t,:) = sVA_from_Parms(theta,gamma,psiX,psiG,psiNX,Phi,Omega);
end

% V3 Changes only the theta values
va_shareproj_os_mean_v3 = zeros(size(Share_is));
for t = 1:T
    theta = theta_shareproj_os_mean_v1(t,:)';
    gamma = gamma_Yproj_os_mean_v1(t,:)';
    psiX = psiX_Yproj_os_mean_v1(t,:)';
    psiG = psiG_Yproj_os_mean_v1(t,:)';
    psiNX = psiNX_Yproj_os_mean_v1(t,:)';
    Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,t));
    Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,t));
    if t > T_is
        % theta = theta_shareproj_os_mean_v1(T_is,:)';
        gamma = gamma_Yproj_os_mean_v1(T_is,:)';
        psiX = psiX_Yproj_os_mean_v1(T_is,:)';
        psiG = psiG_Yproj_os_mean_v1(T_is,:)';
        psiNX = psiNX_Yproj_os_mean_v1(T_is,:)';
        Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,T_is));
        Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,T_is));
    end
    va_shareproj_os_mean_v3(t,:) = sVA_from_Parms(theta,gamma,psiX,psiG,psiNX,Phi,Omega);
end

% V4 Changes only the gamma values
va_shareproj_os_mean_v4 = zeros(size(Share_is));
for t = 1:T
    theta = theta_shareproj_os_mean_v1(t,:)';
    gamma = gamma_Yproj_os_mean_v1(t,:)';
    psiX = psiX_Yproj_os_mean_v1(t,:)';
    psiG = psiG_Yproj_os_mean_v1(t,:)';
    psiNX = psiNX_Yproj_os_mean_v1(t,:)';
    Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,t));
    Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,t));
    if t > T_is
        theta = theta_shareproj_os_mean_v1(T_is,:)';
        % gamma = gamma_Yproj_os_mean_v1(T_is,:)';
        psiX = psiX_Yproj_os_mean_v1(T_is,:)';
        psiG = psiG_Yproj_os_mean_v1(T_is,:)';
        psiNX = psiNX_Yproj_os_mean_v1(T_is,:)';
        Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,T_is));
        Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,T_is));
    end
    va_shareproj_os_mean_v4(t,:) = sVA_from_Parms(theta,gamma,psiX,psiG,psiNX,Phi,Omega);
end

% V5: Only Changes Phi and Omega
va_shareproj_os_mean_v5 = zeros(size(Share_is));
for t = 1:T
    theta = theta_shareproj_os_mean_v1(t,:)';
    gamma = gamma_Yproj_os_mean_v1(t,:)';
    psiX = psiX_Yproj_os_mean_v1(t,:)';
    psiG = psiG_Yproj_os_mean_v1(t,:)';
    psiNX = psiNX_Yproj_os_mean_v1(t,:)';
    Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,t));
    Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,t));
    if t > T_is
        theta = theta_shareproj_os_mean_v1(T_is,:)';
        gamma = gamma_Yproj_os_mean_v1(T_is,:)';
        % psiX = psiX_Yproj_os_mean_v1(T_is,:)';
        psiG = psiG_Yproj_os_mean_v1(T_is,:)';
        psiNX = psiNX_Yproj_os_mean_v1(T_is,:)';
        Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,T_is));
        Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,T_is));
    end
    va_shareproj_os_mean_v5(t,:) = sVA_from_Parms(theta,gamma,psiX,psiG,psiNX,Phi,Omega);
end

% V6 Only change psiNX
va_shareproj_os_mean_v6 = zeros(size(Share_is));
for t = 1:T
    theta = theta_shareproj_os_mean_v1(t,:)';
    gamma = gamma_Yproj_os_mean_v1(t,:)';
    psiX = psiX_Yproj_os_mean_v1(t,:)';
    psiG = psiG_Yproj_os_mean_v1(t,:)';
    psiNX = psiNX_Yproj_os_mean_v1(t,:)';
    Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,t));
    Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,t));
    if t > T_is
        theta = theta_shareproj_os_mean_v1(T_is,:)';
        gamma = gamma_Yproj_os_mean_v1(T_is,:)';
        psiX = psiX_Yproj_os_mean_v1(T_is,:)';
        psiG = psiG_Yproj_os_mean_v1(T_is,:)';
        % psiNX = psiNX_Yproj_os_mean_v1(T_is,:)';
        Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,T_is));
        Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,T_is));
    end
    va_shareproj_os_mean_v6(t,:) = sVA_from_Parms(theta,gamma,psiX,psiG,psiNX,Phi,Omega);
end

% V7 Only psiG
va_shareproj_os_mean_v7 = zeros(size(Share_is));
for t = 1:T
    theta = theta_shareproj_os_mean_v1(t,:)';
    gamma = gamma_Yproj_os_mean_v1(t,:)';
    psiX = psiX_Yproj_os_mean_v1(t,:)';
    psiG = psiG_Yproj_os_mean_v1(t,:)';
    psiNX = psiNX_Yproj_os_mean_v1(t,:)';
    Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,t));
    Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,t));
    if t > T_is
        theta = theta_shareproj_os_mean_v1(T_is,:)';
        gamma = gamma_Yproj_os_mean_v1(T_is,:)';
        psiX = psiX_Yproj_os_mean_v1(T_is,:)';
        % psiG = psiG_Yproj_os_mean_v1(T_is,:)';
        psiNX = psiNX_Yproj_os_mean_v1(T_is,:)';
        Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,T_is));
        Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,T_is));
    end
    va_shareproj_os_mean_v7(t,:) = sVA_from_Parms(theta,gamma,psiX,psiG,psiNX,Phi,Omega);
end

% V8 Only Phi
va_shareproj_os_mean_v8 = zeros(size(Share_is));
for t = 1:T
    theta = theta_shareproj_os_mean_v1(t,:)';
    gamma = gamma_Yproj_os_mean_v1(t,:)';
    psiX = psiX_Yproj_os_mean_v1(t,:)';
    psiG = psiG_Yproj_os_mean_v1(t,:)';
    psiNX = psiNX_Yproj_os_mean_v1(t,:)';
    Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,t));
    Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,t));
    if t > T_is
        theta = theta_shareproj_os_mean_v1(T_is,:)';
        gamma = gamma_Yproj_os_mean_v1(T_is,:)';
        psiX = psiX_Yproj_os_mean_v1(T_is,:)';
        psiG = psiG_Yproj_os_mean_v1(T_is,:)';
        psiNX = psiNX_Yproj_os_mean_v1(T_is,:)';
        % Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,T_is));
        Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,T_is));
    end
    va_shareproj_os_mean_v8(t,:) = sVA_from_Parms(theta,gamma,psiX,psiG,psiNX,Phi,Omega);
end


% V9 Only Phi
va_shareproj_os_mean_v9 = zeros(size(Share_is));
for t = 1:T
    theta = theta_shareproj_os_mean_v1(t,:)';
    gamma = gamma_Yproj_os_mean_v1(t,:)';
    psiX = psiX_Yproj_os_mean_v1(t,:)';
    psiG = psiG_Yproj_os_mean_v1(t,:)';
    psiNX = psiNX_Yproj_os_mean_v1(t,:)';
    Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,t));
    Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,t));
    if t > T_is
        theta = theta_shareproj_os_mean_v1(T_is,:)';
        gamma = gamma_Yproj_os_mean_v1(T_is,:)';
        psiX = psiX_Yproj_os_mean_v1(T_is,:)';
        psiG = psiG_Yproj_os_mean_v1(T_is,:)';
        psiNX = psiNX_Yproj_os_mean_v1(T_is,:)';
        Phi = squeeze(Phi_shareproj_os_mean_v1(:,:,T_is));
        % Omega = squeeze(Omega_shareproj_os_mean_v1(:,:,T_is));
    end
    va_shareproj_os_mean_v9(t,:) = sVA_from_Parms(theta,gamma,psiX,psiG,psiNX,Phi,Omega);
end


va_share_proj_1947_v2 = 100*va_shareproj_os_mean_v2(1,:);
va_share_proj_2018_v2 = 100*va_shareproj_os_mean_v2(T_is,:);
va_share_proj_fcst_v2 = 100*va_shareproj_os_mean_v2(T_fcst,:);

va_share_proj_1947_v3 = 100*va_shareproj_os_mean_v3(1,:);
va_share_proj_2018_v3 = 100*va_shareproj_os_mean_v3(T_is,:);
va_share_proj_fcst_v3 = 100*va_shareproj_os_mean_v3(T_fcst,:);

va_share_proj_1947_v4 = 100*va_shareproj_os_mean_v4(1,:);
va_share_proj_2018_v4 = 100*va_shareproj_os_mean_v4(T_is,:);
va_share_proj_fcst_v4 = 100*va_shareproj_os_mean_v4(T_fcst,:);

va_share_proj_1947_v5 = 100*va_shareproj_os_mean_v5(1,:);
va_share_proj_2018_v5 = 100*va_shareproj_os_mean_v5(T_is,:);
va_share_proj_fcst_v5 = 100*va_shareproj_os_mean_v5(T_fcst,:);

va_share_proj_1947_v6 = 100*va_shareproj_os_mean_v6(1,:);
va_share_proj_2018_v6 = 100*va_shareproj_os_mean_v6(T_is,:);
va_share_proj_fcst_v6 = 100*va_shareproj_os_mean_v6(T_fcst,:);

va_share_proj_1947_v7 = 100*va_shareproj_os_mean_v7(1,:);
va_share_proj_2018_v7 = 100*va_shareproj_os_mean_v7(T_is,:);
va_share_proj_fcst_v7 = 100*va_shareproj_os_mean_v7(T_fcst,:);

va_share_proj_1947_v8 = 100*va_shareproj_os_mean_v8(1,:);
va_share_proj_2018_v8 = 100*va_shareproj_os_mean_v8(T_is,:);
va_share_proj_fcst_v8 = 100*va_shareproj_os_mean_v8(T_fcst,:);

va_share_proj_1947_v9 = 100*va_shareproj_os_mean_v9(1,:);
va_share_proj_2018_v9 = 100*va_shareproj_os_mean_v9(T_is,:);
va_share_proj_fcst_v9 = 100*va_shareproj_os_mean_v9(T_fcst,:);

% Save some things to the table

fprintf(fid,'\n');
fprintf(fid,'\n');
fprintf(fid,'Changes by Component \n');
fprintf(fid,'Theta,,');
fprintf(fid,fmt_str,va_share_proj_fcst_v3-va_share_proj_2018_v3);
fprintf(fid,'\n');
fprintf(fid,'Gamma,,');
fprintf(fid,fmt_str,va_share_proj_fcst_v4-va_share_proj_2018_v4);
fprintf(fid,'\n');
fprintf(fid,'Phi,,');
fprintf(fid,fmt_str,va_share_proj_fcst_v9-va_share_proj_2018_v9);
fprintf(fid,'\n');
fprintf(fid,'Omega,,');
fprintf(fid,fmt_str,va_share_proj_fcst_v8-va_share_proj_2018_v8);
fprintf(fid,'\n');
fprintf(fid,'psiX,,');
fprintf(fid,fmt_str,va_share_proj_fcst_v5-va_share_proj_2018_v5);
fprintf(fid,'\n');
fprintf(fid,'psiNX,,');
fprintf(fid,fmt_str,va_share_proj_fcst_v6-va_share_proj_2018_v6);
fprintf(fid,'\n');
fprintf(fid,'psiG,,');
fprintf(fid,fmt_str,va_share_proj_fcst_v7-va_share_proj_2018_v7);


fprintf(fid,'\n');
fprintf(fid,'\n');
fprintf(fid,'Total Bottom Up Forecasts,,');
tmp1 = va_share_proj_fcst_v3 + va_share_proj_fcst_v4 + va_share_proj_fcst_v5 + va_share_proj_fcst_v6 + va_share_proj_fcst_v7 + va_share_proj_fcst_v8 + va_share_proj_fcst_v9;
tmp2 = va_share_proj_2018_v3 + va_share_proj_2018_v4 + va_share_proj_2018_v5 + va_share_proj_2018_v6 + va_share_proj_2018_v7 + va_share_proj_2018_v8 + va_share_proj_2018_v9;
fprintf(fid,fmt_str,tmp1-tmp2);
fprintf(fid,'\n');
fclose(fid);